/*
 * Decompiled with CFR 0.152.
 */
package fme;

import fme.CBData;
import fme.CBData_Comum;
import fme.CFType;
import fme.CFTypeNumber;
import fme.CFType_AnoMes;
import fme.CFType_Data;
import fme.CFType_Formula;
import fme.CFType_ValorS;
import fme.CHEnvio;
import fme.CHTabColModel;
import fme.CHTabQuadro;
import fme.CHTabela;
import fme.CHValid_Msg;
import fme.CTabela;
import fme.GroupableTableHeaderUI;
import fme.JTable_Tip;
import fme.TabError;
import fme.XMLDataHandler;
import fme._lib;
import fme.fmeFrame;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.table.TableColumn;

class CBTabela
extends XMLDataHandler
implements CBData_Comum {
    static final int XML_READ = 1;
    static final int XML_WRITE = 2;
    CHTabColModel[] cols;
    Vector<String[]> dados = new Vector();
    int df_nlines;
    int keyCol = -1;
    int idx_xml = -1;
    CHTabela handler = null;
    boolean force_xml = false;
    GroupableTableHeaderUI ui = null;
    boolean started = false;
    boolean corrompido = false;
    public CBTabela fixed_buddy = null;
    public boolean on_fixed_buddy = false;
    private static final Pattern mustQuote = Pattern.compile("[\t\r\n]");
    private static final String quotedCell = "\"(?:[^\"]*\"\")*[^\"]*\"";
    private static final Pattern hasQuotes = Pattern.compile("(^|\t|\r?\n)(\"(?:[^\"]*\"\")*[^\"]*\")(\t|\r?\n|$)");
    private static final Pattern splitCell = Pattern.compile("(?s)(\"(?:[^\"]*\"\")*[^\"]*\"|.*?)(\t|\r?\n|$)");
    private static final Pattern isQuoted = Pattern.compile("\"(?:[^\"]*\"\")*[^\"]*\"");
    public static String excel_password = null;
    private static final Pattern numberMatch = Pattern.compile("[-0-9.E]*");

    void init_handler(JTable_Tip _j) {
        this.handler = new CHTabela();
        this._init_handler(_j);
    }

    void init_handler(CHTabela _handler, JTable_Tip _j) {
        this.handler = _handler;
        this._init_handler(_j);
    }

    void init_handler(CHTabela _handler, JTable_Tip _j1, JTable_Tip _j2) {
        this.handler = _handler;
        this._init_handler(_j1);
        this._init_handler(_j2);
    }

    void _init_handler(JTable_Tip _j) {
        _j.setCellSelectionEnabled(false);
        _j.setRowSelectionAllowed(true);
        _j.setColumnSelectionAllowed(false);
        int nt_cols = 0;
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].visible) {
                this.cols[i].t_col = nt_cols++;
            }
            ++i;
        }
        this.handler.cdx = new int[nt_cols];
        int n = 0;
        int i2 = 0;
        while (i2 < this.cols.length) {
            if (this.cols[i2].visible) {
                this.handler.cdx[n++] = i2;
            }
            ++i2;
        }
        this.handler.setup(_j, this);
    }

    public int true_col(int j) {
        int t = this.cols[j].t_col;
        if (t > 0) {
            return t;
        }
        if (this.handler != null && this.handler.cdx[0] == j) {
            return 0;
        }
        return -1;
    }

    @Override
    public String xmlPrint() {
        if (!this.started) {
            return "";
        }
        int nRows = this.dados.size();
        int nCols = this.cols.length;
        String xml = new String();
        xml = "";
        int i = 0;
        while (i < nRows) {
            String xml_reg = new String();
            boolean has_data = false;
            xml_reg = "<Reg>\n";
            int j = 0;
            while (j < nCols) {
                if (this.cols[j].xml_write) {
                    String v = this.dados.elementAt(i)[j];
                    if ((this.force_xml || this.cols[j].editable) && v.length() > 0) {
                        has_data = true;
                    }
                    xml_reg = String.valueOf(xml_reg) + _lib.xml_encode(this.cols[j].col_tag, v);
                    xml_reg = String.valueOf(xml_reg) + this.on_xml(this.cols[j].col_tag, i, v);
                }
                ++j;
            }
            xml_reg = String.valueOf(xml_reg) + this.xmlPrintInternal(i);
            xml_reg = String.valueOf(xml_reg) + "</Reg>\n";
            if (has_data) {
                xml = String.valueOf(xml) + "\n" + xml_reg;
            }
            ++i;
        }
        return xml;
    }

    String xmlPrintInternal(int row) {
        return "";
    }

    @Override
    public void xmlBegin(String path) {
        ++this.idx_xml;
        if (this.idx_xml >= this.dados.size()) {
            if (this.keyCol == -1) {
                this.add_row();
            } else {
                this.idx_xml = -1;
            }
        }
    }

    @Override
    public void xmlValue(String path, String tag, String v) {
        int i = this.idx_xml;
        int j = this.getColIndex(tag);
        if (j < 0) {
            return;
        }
        if (j == this.keyCol) {
            int k = 0;
            while (k < this.dados.size()) {
                if (v.equals(this.dados.elementAt(k)[this.keyCol])) {
                    this.idx_xml = k;
                    return;
                }
                ++k;
            }
            this.idx_xml = -1;
        }
        if (this.idx_xml == -1) {
            return;
        }
        if (!this.cols[j].xml_read) {
            return;
        }
        if (v.equals("0") && this.cols[j].vld != null && this.cols[j].vld instanceof CFType_ValorS) {
            v = "";
        }
        if (this.handler instanceof CHTabQuadro && ((CHTabQuadro)this.handler).row_vld[i] != null) {
            ((CHTabQuadro)this.handler).row_vld[i].setString(v);
            v = ((CHTabQuadro)this.handler).row_vld[i].getString();
        } else if (this.cols[j].vld != null) {
            this.cols[j].vld.setString(v);
            v = this.cols[j].vld.getString();
        }
        this.dados.elementAt((int)i)[j] = v;
        this.on_update(tag, i, v);
    }

    CHTabColModel getCol(String name) {
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.equals(name)) {
                return this.cols[i];
            }
            ++i;
        }
        return null;
    }

    int getColIndex(String name) {
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_tag.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    int getColIndexByName(String name) {
        int i = 0;
        while (i < this.cols.length) {
            if (this.cols[i].col_name.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void updateValue(String name, int i, String v) {
        int n = this.getColIndex(name);
        if (!this.dados.elementAt(i)[n].equals(v)) {
            this.dados.elementAt((int)i)[n] = v;
            this.on_update(name, i, v);
        }
    }

    void updateValue(int n, int i, String v) {
        if (!this.dados.elementAt(i)[n].equals(v)) {
            this.dados.elementAt((int)i)[n] = v;
            this.on_update(this.cols[n].col_tag, i, v);
        }
    }

    void setColValue(String name, int i, String v) {
        int n = this.getColIndex(name);
        this.dados.elementAt((int)i)[n] = v;
    }

    void setColValue(int n, int i, String v) {
        this.dados.elementAt((int)i)[n] = v;
    }

    String getColValue(String name, int i) {
        int n = this.getColIndex(name);
        return this.dados.elementAt(i)[n];
    }

    String getColValue(int n, int i) {
        return this.dados.elementAt(i)[n];
    }

    String getEditString(String name, int i) {
        int n = this.getColIndex(name);
        String s = this.dados.elementAt(i)[n];
        if (this.cols[n].vld == null) {
            return s;
        }
        this.cols[n].vld.setValue(s);
        return this.cols[n].vld.getEditString();
    }

    double getColValueAsDouble(String name, int i) {
        int n = this.getColIndex(name);
        if (this.cols[n].vld != null) {
            String s = this.dados.elementAt(i)[n];
            return this.cols[n].vld.stringToDouble(s);
        }
        return 0.0;
    }

    double getColValueAsDouble(int n, int i) {
        if (this.cols[n].vld != null) {
            String s = this.dados.elementAt(i)[n];
            return this.cols[n].vld.stringToDouble(s);
        }
        return 0.0;
    }

    public void add_row() {
        String[] col = new String[this.cols.length];
        int j = 0;
        while (j < this.cols.length) {
            col[j] = "";
            ++j;
        }
        this.dados.addElement(col);
    }

    public void ins_row_at(int n) {
        String[] col = new String[this.cols.length];
        int j = 0;
        while (j < this.cols.length) {
            col[j] = "";
            ++j;
        }
        this.dados.insertElementAt(col, n);
        int i = this.dados.size() - 1;
        while (i > n) {
            if (this.isRowEmpty(i)) {
                this.del_row_at(i);
                break;
            }
            --i;
        }
        int x = this.dados.size();
    }

    public void del_row_at(int n) {
        this.dados.removeElementAt(n);
        if (this.dados.size() < this.df_nlines) {
            String[] col = new String[this.cols.length];
            int j = 0;
            while (j < this.cols.length) {
                col[j] = "";
                ++j;
            }
            this.dados.addElement(col);
        }
    }

    void init_dados(int n) {
        this.df_nlines = n;
        this.dados = new Vector();
        int i = 0;
        while (i < this.df_nlines) {
            String[] col = new String[this.cols.length];
            int j = 0;
            while (j < this.cols.length) {
                if (this.cols[j].editable) {
                    col[j] = "";
                }
                if (col[j] == null) {
                    col[j] = "";
                }
                ++j;
            }
            this.dados.addElement(col);
            ++i;
        }
    }

    public void Clear() {
        int i = 0;
        while (i < this.dados.size()) {
            this.clearRow(i);
            ++i;
        }
        this.idx_xml = -1;
        this.handler.j.repaint();
    }

    void clearRow(int i) {
        int j = 0;
        while (j < this.cols.length) {
            if (this.cols[j].editable) {
                this.dados.elementAt((int)i)[j] = "";
            }
            if (this.dados.elementAt(i)[j] == null) {
                this.dados.elementAt((int)i)[j] = "";
            }
            this.on_update(this.cols[j].col_tag, i, "");
            ++j;
        }
    }

    void on_update(String colname, int nRow, String v) {
    }

    @Override
    public void on_external_update(String tag) {
    }

    String on_xml(String colname, int row, String v) {
        return "";
    }

    void validar() {
    }

    double getSum(String colName) {
        double v = 0.0;
        int n = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            String s = this.dados.elementAt(i)[n];
            if (s.length() > 0) {
                v = _lib.round(v + Double.parseDouble(s));
            }
            ++i;
        }
        return v;
    }

    double getSum_v25b(String colName) {
        double v = 0.0;
        int n = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            if (this.cols[n].vld != null) {
                String s = this.dados.elementAt(i)[n];
                v += this.cols[n].vld.stringToDouble(s);
            }
            ++i;
        }
        return v;
    }

    double getMax(String colName) {
        double v = 0.0;
        int n = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            double vx;
            String s = this.dados.elementAt(i)[n];
            if (s.length() > 0 && (vx = Double.parseDouble(s)) > v) {
                v = vx;
            }
            ++i;
        }
        return v;
    }

    int getCountIf(String colName, String v) {
        int n = 0;
        int col = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            String s = this.dados.elementAt(i)[col];
            if (s.equals(v)) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    boolean isUnique(String colName) {
        int n = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            int k = i + 1;
            while (k < nRows) {
                String s1 = this.dados.elementAt(i)[n];
                String s2 = this.dados.elementAt(k)[n];
                if (s1.length() > 0 && s1.equals(s2)) {
                    return false;
                }
                ++k;
            }
            ++i;
        }
        return true;
    }

    TabError isIncomplet(String mask) {
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            TabError e = this.isIncomplet(i, mask);
            if (e != null) {
                return e;
            }
            ++i;
        }
        return null;
    }

    TabError isIncomplet(int row, String mask) {
        String s;
        int nCols = this.cols.length;
        boolean has_line = false;
        int j = 0;
        while (j < nCols && !has_line) {
            s = this.dados.elementAt(row)[j];
            if (s != null && s.length() > 0) {
                has_line = true;
            }
            ++j;
        }
        j = 0;
        while (j < nCols) {
            s = this.dados.elementAt(row)[j];
            if (has_line && s.length() == 0 && mask.charAt(j) == 'R') {
                return new TabError(row, j, 'R', this.cols[j].col_tag, this.cols[j].col_name);
            }
            if (s.length() > 0 && mask.charAt(j) == 'N') {
                return new TabError(row, j, 'N', this.cols[j].col_tag, this.cols[j].col_name);
            }
            ++j;
        }
        return null;
    }

    TabError[] isIncompletAll(int row, String mask) {
        String s;
        int nCols = this.cols.length;
        boolean has_line = false;
        int j = 0;
        while (j < nCols && !has_line) {
            s = this.dados.elementAt(row)[j];
            if (s != null && s.length() > 0) {
                has_line = true;
            }
            ++j;
        }
        TabError[] elist = new TabError[nCols];
        int nErros = 0;
        j = 0;
        while (j < nCols) {
            s = this.dados.elementAt(row)[j];
            if (has_line && s.trim().length() == 0 && mask.charAt(j) == 'R') {
                elist[nErros++] = new TabError(row, j, 'R', this.cols[j].col_tag, this.cols[j].col_name);
            }
            if (s.length() > 0 && mask.charAt(j) == 'N') {
                elist[nErros++] = new TabError(row, j, 'N', this.cols[j].col_tag, this.cols[j].col_name);
            }
            ++j;
        }
        TabError[] rlist = new TabError[nErros];
        System.arraycopy(elist, 0, rlist, 0, nErros);
        return rlist;
    }

    boolean isRowEmpty(int row) {
        int j = 0;
        while (j < this.cols.length) {
            String s;
            if (this.cols[j].editable && (s = this.dados.elementAt(row)[j]).length() > 0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    boolean isEmpty() {
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            if (!this.isRowEmpty(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    int lookup(String colName, String key) {
        int n = this.getColIndex(colName);
        int nRows = this.dados.size();
        int i = 0;
        while (i < nRows) {
            String s = this.dados.elementAt(i)[n];
            if (s.length() > 0 && s.equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void locate(CHValid_Msg m) {
        String s = fmeFrame.Paginas.getTag();
        if (this.getPagina() == null) {
            return;
        }
        if (!s.equals(this.getPagina())) {
            fmeFrame.Paginas.GoTo(this.getPagina());
        }
        this.handler.j.requestFocus();
        Rectangle rect = this.handler.j.getTableHeader().getBounds();
        rect.setLocation(0, -rect.height);
        if (m.row >= 0 && m.col >= 0) {
            int m_col = this.cols[m.col].t_col;
            this.handler.j.setColumnSelectionInterval(m_col, m_col);
            this.handler.j.setRowSelectionInterval(m.row, m.row);
            this.on_row(m.row);
            if (this.handler.j.isCellEditable(m.row, m_col)) {
                this.handler.j.editCellAt(m.row, m_col);
            }
            if (this.handler.j.getParent() instanceof JViewport) {
                JViewport viewport = (JViewport)this.handler.j.getParent();
                rect = this.handler.j.getCellRect(m.row, m_col, true);
                Point point = viewport.getViewPosition();
                rect.setLocation(rect.x - point.x, rect.y - point.y);
                viewport.scrollRectToVisible(rect);
                rect = this.handler.j.getCellRect(m.row, m_col, true);
                point = viewport.getViewPosition();
                rect.setLocation(rect.x - point.x, rect.y - point.y);
            }
        }
        Container sp = this.handler.j.getParent();
        int nsp = 0;
        int want_scroll_panes = 1;
        if (sp.getParent() instanceof JScrollPane) {
            want_scroll_panes = 2;
        }
        while (nsp < want_scroll_panes) {
            if (sp == null) {
                return;
            }
            rect.x += sp.getX();
            rect.y += sp.getY();
            if (!((sp = sp.getParent()) instanceof JScrollPane)) continue;
            ++nsp;
        }
        JViewport viewport = ((JScrollPane)sp).getViewport();
        viewport.scrollRectToVisible(new Rectangle(rect.x - 64, rect.y - 64, Math.min(rect.width, 128) + 128, Math.min(rect.height, 64) + 128));
    }

    @Override
    public String getPagina() {
        return null;
    }

    void numerar(int nCol) {
        int n = 0;
        int i = 0;
        while (i < this.dados.size()) {
            this.dados.elementAt((int)i)[nCol] = !this.isRowEmpty(i) ? Integer.toString(++n) : "";
            ++i;
        }
    }

    static String html(String text) {
        return "<html><div align='center'>" + text + "</div></html>";
    }

    void autocalc2(boolean zero_tt, boolean edit, int dec) {
        int i = 0;
        while (i < this.cols.length) {
            if ((this.cols[i].editable || edit) && this.cols[i].autocalc != null) {
                String conta;
                String formula = this.cols[i].autocalc;
                if (formula.startsWith("$soma")) {
                    conta = formula.substring(6, formula.length() - 1);
                    this._autocalc_soma(i, conta);
                }
                if (formula.startsWith("$perc")) {
                    conta = formula.substring(6, formula.length() - 1);
                    this._autocalc_perc(i, conta);
                }
            }
            ++i;
        }
        if (this.handler != null && this.handler instanceof CHTabQuadro) {
            this._autocalc_rows(zero_tt, dec);
        }
    }

    void autocalc() {
        this.autocalc2(false, true, 2);
    }

    void _autocalc_soma(int nCol, String formula) {
        String[] termos = formula.split(",");
        int r = 0;
        while (r < this.dados.size()) {
            double v = 0.0;
            double sv = 0.0;
            int t = 0;
            while (t < termos.length) {
                if (!termos[t].equals("+x") && !termos[t].equals("-x")) {
                    int n = Integer.parseInt(termos[t].substring(1));
                    char conta = termos[t].charAt(0);
                    sv = 0.0;
                    String s = this.dados.elementAt(r)[n];
                    if (s.length() > 0) {
                        sv = Double.parseDouble(s);
                    }
                    if (s.length() > 0 && conta == '+') {
                        v += sv;
                    }
                    if (s.length() > 0 && conta == '-') {
                        v -= sv;
                    }
                    if (v != 0.0) {
                        v = _lib.round(v);
                    }
                }
                ++t;
            }
            this.dados.elementAt((int)r)[nCol] = v == 0.0 ? "" : _lib.to_string(v);
            ++r;
        }
    }

    void _autocalc_perc(int nCol, String formula) {
        String s;
        String[] termos = formula.split(",");
        double base = 0.0;
        if (termos[1].charAt(0) == '@' && (s = this.getParam(termos[1].substring(1))).length() > 0) {
            base = Double.parseDouble(s);
        }
        int r = 0;
        while (r < this.dados.size()) {
            double v = 0.0;
            if (base != 0.0) {
                int n = Integer.parseInt(termos[0].substring(1));
                String s2 = this.dados.elementAt(r)[n];
                if (s2.length() > 0) {
                    v = Double.parseDouble(s2);
                }
                v /= base;
            }
            this.dados.elementAt((int)r)[nCol] = v == 0.0 ? "" : _lib.to_string(v * 100.0);
            ++r;
        }
    }

    void _autocalc_rows(boolean zero_tt, int dec) {
        CHTabQuadro h = (CHTabQuadro)this.handler;
        int i = 0;
        while (i < h.row_autocalc.length) {
            String formula;
            if (h.row_autocalc[i] != null && (formula = h.row_autocalc[i]).startsWith("$soma")) {
                String conta = formula.substring(6, formula.length() - 1);
                this._autocalc_rows_soma(i, conta, zero_tt, dec);
            }
            ++i;
        }
    }

    void _autocalc_rows_soma(int nRow, String formula, boolean zero_tt, int dec) {
        String[] termos = formula.split(",");
        int c = 0;
        while (c < this.cols.length) {
            if (this.cols[c].vld != null && !this.cols[c].disable_row_calc) {
                double v = 0.0;
                double sv = 0.0;
                boolean tem_par = false;
                int t = 0;
                while (t < termos.length) {
                    if (!termos[t].equals("+x") && !termos[t].equals("-x")) {
                        int n = Integer.parseInt(termos[t].substring(1));
                        char conta = termos[t].charAt(0);
                        String s = this.dados.elementAt(n)[c];
                        sv = 0.0;
                        if (s.length() > 0) {
                            sv = Double.parseDouble(s);
                        }
                        if (sv != 0.0) {
                            sv = _lib.round_dec(sv, dec);
                        }
                        if (s.length() > 0 && conta == '+') {
                            v += sv;
                        }
                        if (s.length() > 0 && conta == '-') {
                            v -= sv;
                        }
                        if (s.length() > 0) {
                            tem_par = true;
                        }
                        if (v != 0.0) {
                            v = _lib.round_dec(v, dec);
                        }
                    }
                    ++t;
                }
                this.dados.elementAt((int)nRow)[c] = v == 0.0 ? (zero_tt && tem_par ? _lib.to_string(v) : "") : _lib.to_string(v);
            }
            ++c;
        }
    }

    @Override
    public String getParam(String param) {
        return null;
    }

    boolean on_del_row() {
        return this.on_del_row(false);
    }

    boolean on_del_row(boolean cascade) {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        int m = this.handler.j.getRowCount();
        if (n < m && n != -1) {
            Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
            int q = JOptionPane.showOptionDialog(null, "<html>A linha selecionada " + (cascade ? "<strong><u>e toda a informa\u00e7\u00e3o associada</u></strong> " : "") + "ser\u00e1 eliminada. Pretende continuar?</html>", "Apagar Linha", 0, 3, null, options, options[1]);
            if (q == 0) {
                this.del_row_at(n);
                this.handler.j.revalidate();
                this.handler.j.repaint();
                return true;
            }
        } else {
            JOptionPane.showMessageDialog(null, "N\u00e3o selecionou nenhuma linha na tabela!", "Apagar Linha", 1, null);
        }
        return false;
    }

    boolean on_add_row() {
        this.add_row();
        this.handler.j.revalidate();
        this.handler.j.repaint();
        return true;
    }

    boolean on_ins_row() {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        if (n >= 0) {
            this.ins_row_at(n);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    boolean on_up_row() {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        if (n >= 1) {
            String[] line_1 = this.dados.elementAt(n - 1);
            String[] line_2 = this.dados.elementAt(n);
            this.dados.setElementAt(line_2, n - 1);
            this.dados.setElementAt(line_1, n);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    boolean on_copy_row() {
        this.handler.__garbage_stop_editing();
        int n = this.handler.j.getSelectedRow();
        if (n >= 0) {
            this.ins_row_at(n + 1);
            String[] col_ = this.dados.elementAt(n);
            String[] col = new String[this.cols.length];
            int j = 0;
            while (j < this.cols.length) {
                col[j] = col_[j];
                ++j;
            }
            this.dados.setElementAt(col, n + 1);
            this.handler.j.revalidate();
            this.handler.j.repaint();
            return true;
        }
        return false;
    }

    double getAsValue(int i, int j) {
        String s = this.dados.elementAt(i)[j];
        return _lib.to_double(s);
    }

    void on_row(int i) {
    }

    private boolean is_row_empty(int i) {
        String[] row = this.dados.elementAt(i);
        int h = 0;
        while (h < this.handler.cdx.length) {
            int j = this.handler.cdx[h];
            if (row[j].length() > 0) {
                return false;
            }
            ++h;
        }
        return true;
    }

    public void on_copy_data() {
        CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
        this.handler.__garbage_stop_editing();
        int true_size = this.dados.size();
        if (quadro == null && this.fixed_buddy == null) {
            while (true_size > 0 && this.is_row_empty(true_size - 1)) {
                --true_size;
            }
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < true_size) {
            if (this.fixed_buddy != null) {
                this.fixed_buddy.copy_data_row(i, sb);
            }
            this.copy_data_row(i, sb);
            sb.setCharAt(sb.length() - 1, '\n');
            ++i;
        }
        StringSelection s = new StringSelection(sb.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(s, null);
    }

    private void copy_data_row(int i, StringBuffer sb) {
        CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
        String[] row = this.dados.elementAt(i);
        int h = 0;
        while (h < this.handler.cdx.length) {
            CFType vld;
            int j = this.handler.cdx[h];
            String cell = row[j];
            boolean qv = quadro != null && quadro.row_vld[i] != null && this.cols[j].editable;
            CFType cFType = vld = qv ? quadro.row_vld[i] : this.cols[j].vld;
            if (cell.length() != 0 && vld != null) {
                try {
                    vld.setString(cell);
                    cell = vld.getText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (cell.startsWith("\"") || mustQuote.matcher(cell).find(0)) {
                cell = "\"" + cell.replace("\"", "\"\"") + "\"";
            }
            sb.append(cell);
            sb.append('\t');
            ++h;
        }
    }

    public void on_paste_data() {
        block16: {
            try {
                String msg;
                CHTabQuadro quadro;
                String[] rows = CBTabela.clipboard_get_rows();
                if (rows.length == 0) {
                    JOptionPane.showMessageDialog(null, "N\u00e3o existe texto na \u00e1rea de transfer\u00eancia.", "Colar", 1);
                    return;
                }
                CHTabQuadro cHTabQuadro = quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
                if (quadro != null && this.dados.size() != rows.length) {
                    JOptionPane.showMessageDialog(null, "A estrutura que est\u00e1 a copiar do Clipboard n\u00e3o coincide com a da tabela.\nP.f. respeite o n\u00ba de linhas.", "Copiar do Clipboard", 0, null);
                    return;
                }
                this.handler.__garbage_stop_editing();
                int true_size = this.dados.size();
                if (quadro == null) {
                    while (true_size > 0 && this.is_row_empty(true_size - 1)) {
                        --true_size;
                    }
                }
                if (true_size == 0) {
                    msg = "colar " + rows.length + " linha" + (rows.length == 1 ? "" : "s");
                } else {
                    int replace = Math.min(true_size, rows.length);
                    msg = "substituir " + replace + " linha" + (replace == 1 ? "" : "s");
                    if (rows.length > true_size) {
                        msg = String.valueOf(msg) + " e adicionar " + (rows.length - true_size);
                    }
                    if (true_size > rows.length) {
                        msg = String.valueOf(msg) + " e apagar " + (true_size - rows.length);
                    }
                }
                Object[] opt = new String[]{"   Sim   ", "   N\u00e3o   "};
                int d = JOptionPane.showOptionDialog(null, "Confirma que quer " + msg + "?", "Colar", 0, 3, null, opt, opt[1]);
                if (d == 1) {
                    return;
                }
                CBData.reading_xml = true;
                int i = 0;
                String[] stringArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    String row = stringArray[n2];
                    if (i == this.dados.size()) {
                        if (quadro != null) break;
                        this.on_add_row();
                    }
                    String[] cells = CBTabela.cliprow_get_columns(row);
                    int c = 0;
                    if ((this.fixed_buddy == null || (c = this.fixed_buddy.paste_data_row(i, 0, cells, c, 0)) != -1) && (c = this.paste_data_row(i, 0, cells, c, 1)) != -1) {
                        ++i;
                        ++n2;
                        continue;
                    }
                    break block16;
                }
                while (i < this.dados.size()) {
                    if (this.fixed_buddy != null) {
                        this.fixed_buddy.clear_data_row(i);
                    }
                    this.clear_data_row(i);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CBData.reading_xml = false;
        this.handler.j.revalidate();
        this.handler.j.repaint();
    }

    public void on_paste_data2() {
        try {
            String msg;
            String[] rows = CBTabela.clipboard_get_rows();
            if (rows.length == 0) {
                JOptionPane.showMessageDialog(null, "N\u00e3o existe texto na \u00e1rea de transfer\u00eancia.", "Colar", 1);
                return;
            }
            CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
            int f = this.on_fixed_buddy && this.fixed_buddy != null ? this.fixed_buddy.handler.j.getSelectedColumn() : -1;
            int h = this.on_fixed_buddy && this.fixed_buddy != null ? 0 : this.handler.j.getSelectedColumn();
            int i = this.handler.j.getSelectedRow();
            if (i == -1 || h == -1 && f == -1) {
                JOptionPane.showMessageDialog(null, "P.f. posicione-se na c\u00e9lula para onde pretende copiar os dados.", "Copiar do Clipboard", 0, null);
                return;
            }
            this.handler.__garbage_stop_editing();
            int true_size = this.dados.size();
            if (quadro == null) {
                while (true_size > 0 && this.is_row_empty(true_size - 1)) {
                    --true_size;
                }
            }
            if ((true_size = Math.max(0, true_size - this.handler.j.getSelectedRow())) == 0) {
                msg = "colar " + rows.length + " linha" + (rows.length == 1 ? "" : "s");
            } else {
                int replace = Math.min(true_size, rows.length);
                msg = "alterar " + replace + " linha" + (replace == 1 ? "" : "s");
                if (rows.length > true_size) {
                    msg = String.valueOf(msg) + " e adicionar " + (rows.length - true_size);
                }
            }
            Object[] opt = new String[]{"   Sim   ", "   N\u00e3o   "};
            int d = JOptionPane.showOptionDialog(null, "Confirma que quer " + msg + "?", "Colar", 0, 3, null, opt, opt[1]);
            if (d == 1 || d == -1) {
                return;
            }
            CBData.reading_xml = true;
            String[] stringArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                String row = stringArray[n2];
                if (i == this.dados.size()) {
                    if (quadro != null) break;
                    this.on_add_row();
                }
                String[] cells = CBTabela.cliprow_get_columns(row);
                int c = 0;
                if ((f == -1 || (c = this.fixed_buddy.paste_data_row(i, f, cells, c, 0)) != -1) && (c = this.paste_data_row(i, h, cells, c, 0)) != -1) {
                    ++i;
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CBData.reading_xml = false;
        this.handler.j.revalidate();
        this.handler.j.repaint();
    }

    public boolean isCellPastable(int i, int h) {
        return this.handler.j.isCellEditable(i, h);
    }

    public Object getSelectValues(int h) {
        if (this.handler.j.getColumnModel().getColumn(h).getCellEditor() == null) {
            return null;
        }
        Component e = this.handler.j.getColumnModel().getColumn(h).getCellEditor().getTableCellEditorComponent(this.handler.j, null, false, 0, h);
        if (!(e instanceof JComboBox)) {
            return null;
        }
        Vector<String> select = new Vector<String>();
        int k = 0;
        while (k < ((JComboBox)e).getItemCount()) {
            select.add(((JComboBox)e).getItemAt(k).toString());
            ++k;
        }
        return select;
    }

    public Object getSelectValues(int i, int h) {
        return null;
    }

    protected Object getSelectValues(CTabela tab, int text, Integer value, Integer dep, String deptag) {
        ExcelSelect select = new ExcelSelect();
        ExcelOption option = new ExcelOption("");
        if (dep != null) {
            option.dependsOn = "";
        }
        if (value != null) {
            option.value = "";
        }
        select.dependsOn = deptag;
        select.list.add(option);
        for (Object item : tab.data_table) {
            option = new ExcelOption(((String[])item)[text]);
            select.list.add(option);
            if (value != null) {
                option.value = ((String[])item)[value];
            }
            if (dep == null) continue;
            option.dependsOn = ((String[])item)[dep];
        }
        return select;
    }

    private int paste_data_row(int i, int h, String[] cells, int c, int all) throws Exception {
        CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
        int n_cols = this.handler.cdx.length - h + all;
        while (h < this.handler.cdx.length && c < cells.length && c < n_cols) {
            if (h == this.handler.cdx.length) break;
            if (this.isCellPastable(i, h)) {
                String cell = cells[c];
                int j = this.handler.cdx[h];
                if (cell.length() != 0) {
                    boolean valid = false;
                    Component e = this.handler.j.getCellEditor(i, h).getTableCellEditorComponent(this.handler.j, null, false, i, h);
                    if (e instanceof JComboBox) {
                        int k = 0;
                        while (k < ((JComboBox)e).getItemCount()) {
                            if (((JComboBox)e).getItemAt(k).toString().equals(cell)) {
                                valid = true;
                                break;
                            }
                            ++k;
                        }
                    } else if (e instanceof JTextField) {
                        CFType vld;
                        boolean qv = quadro != null && quadro.row_vld[i] != null && this.cols[j].editable;
                        CFType cFType = vld = qv ? quadro.row_vld[i] : this.cols[j].vld;
                        if (vld == null) {
                            valid = true;
                        } else if (vld.setText(cell, false)) {
                            cell = vld.getString();
                            valid = true;
                        }
                    } else if (e instanceof JCheckBox) {
                        cell = cell.matches("(?i)(|0|f.*)") ? "" : "1";
                        valid = true;
                    } else {
                        throw new Exception("Unhandled component type");
                    }
                    if (!valid) {
                        Object[] opt = new String[]{"   Sim   ", "   N\u00e3o   "};
                        int d = JOptionPane.showOptionDialog(null, "N\u00e3o foi poss\u00edvel colar '" + cell + "' na coluna '" + this.cols[j].col_name.replaceAll("<.*?>", " ").replaceAll("\\s+?", " ").trim() + "'.\n\nPretende continuar?", "Colar", 0, 3, null, opt, opt[1]);
                        if (d == 1 || d == -1) {
                            return -1;
                        }
                        cell = "";
                    }
                }
                this.dados.elementAt((int)i)[j] = cell;
                this.on_update(this.cols[j].col_tag, i, cell);
            }
            ++h;
            ++c;
        }
        return c;
    }

    private void clear_data_row(int i) {
        int h = 0;
        while (h < this.handler.cdx.length) {
            int j = this.handler.cdx[h];
            if (this.isCellPastable(i, h)) {
                this.dados.elementAt((int)i)[j] = "";
                this.on_update(this.cols[j].col_tag, i, "");
            }
            ++h;
        }
    }

    private static String[] clipboard_get_rows() throws Exception {
        String clip;
        Vector<String> list = new Vector<String>();
        Clipboard sys = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (sys.isDataFlavorAvailable(DataFlavor.stringFlavor) && (clip = (String)sys.getData(DataFlavor.stringFlavor)).length() > 0) {
            if (clip.endsWith("\n")) {
                clip = clip.substring(0, clip.length() - 1);
            }
            if (!hasQuotes.matcher(clip).find(0)) {
                return clip.split("\n", -1);
            }
            Matcher match = splitCell.matcher(clip);
            String row = "";
            while (match.find()) {
                if (match.group(2).equals("\t")) {
                    row = String.valueOf(row) + match.group(0);
                } else {
                    list.add(String.valueOf(row) + match.group(1));
                    row = "";
                }
                if (match.group(2).length() == 0) break;
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] cliprow_get_columns(String row) throws Exception {
        if (!hasQuotes.matcher(row).find(0)) {
            return row.split("\t", -1);
        }
        Vector<String> list = new Vector<String>();
        Matcher match = splitCell.matcher(row);
        while (match.find()) {
            String cell = match.group(1);
            if (isQuoted.matcher(cell).matches()) {
                list.add(cell.substring(1, cell.length() - 1).replace("\"\"", "\""));
            } else {
                list.add(cell);
            }
            if (match.group(2).length() == 0) break;
        }
        return list.toArray(new String[list.size()]);
    }

    public void on_excel_file() {
        this.on_excel_file(null);
    }

    public void on_excel_file(JButton face) {
        CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
        this.handler.__garbage_stop_editing();
        int true_size = this.dados.size();
        HashMap<String, Object> sm = new HashMap<String, Object>();
        StringBuffer sb = new StringBuffer();
        sb.append("<table");
        if (excel_password != null) {
            sb.append(" protect='" + excel_password + "'");
        }
        sb.append(">\n");
        sb.append(CBTabela.cell_encode("caption", null, this.get_caption()));
        sb.append("<colgroup>\n");
        if (this.fixed_buddy != null) {
            this.fixed_buddy.excel_columns(sb, sm);
        }
        this.excel_columns(sb, sm);
        sb.append("</colgroup>\n");
        int hh = this.handler.j.getTableHeader().getHeight();
        if (this.ui == null || this.fixed_buddy != null && this.fixed_buddy.ui == null || this.fixed_buddy != null && this.fixed_buddy.ui.H != this.ui.H) {
            sb.append("<thead>\n");
            sb.append("<tr height='" + hh + "'>\n");
            if (this.fixed_buddy != null) {
                this.fixed_buddy.excel_header(sb);
            }
            this.excel_header(sb);
            sb.append("</tr>\n");
        } else {
            hh /= this.ui.H;
            sb.append("<thead rows='" + this.ui.H + "'>\n");
            int y = 0;
            while (y < this.ui.H) {
                sb.append("<tr height='" + hh + "'>\n");
                if (this.fixed_buddy != null) {
                    this.fixed_buddy.excel_ui(y, sb);
                }
                this.excel_ui(y, sb);
                sb.append("</tr>\n");
                ++y;
            }
        }
        sb.append("</thead>\n");
        sb.append("<tbody>\n");
        int i = 0;
        while (i < true_size) {
            sb.append("<tr");
            boolean lock = false;
            if (quadro != null && !quadro.row_editable[i]) {
                sb.append(" locked='true'");
                lock = true;
            }
            if (this.handler.j.getRowHeight(i) != this.handler.j.getRowHeight()) {
                sb.append(" height='" + this.handler.j.getRowHeight(i) + "'");
            }
            sb.append(">\n");
            if (this.fixed_buddy != null) {
                this.fixed_buddy.excel_data_row(i, sb, sm, 0, lock);
                this.excel_data_row(i, sb, sm, this.fixed_buddy.handler.cdx.length, lock);
            } else {
                this.excel_data_row(i, sb, sm, 0, lock);
            }
            sb.append("</tr>\n");
            ++i;
        }
        sb.append("</tbody>\n");
        for (Map.Entry<String, Object> item : sm.entrySet()) {
            if (item.getValue() instanceof ExcelSelect) {
                ExcelSelect select = (ExcelSelect)item.getValue();
                String att = select.dependsOn == null ? "" : "' dep='" + select.dependsOn;
                sb.append("<select id='" + item.getKey() + att + "'>\n");
                for (ExcelOption option : select.list) {
                    att = option.dependsOn == null ? "" : " dep='" + option.dependsOn + "'";
                    att = String.valueOf(att) + (option.value == null ? "" : " value='" + option.value + "'");
                    sb.append(CBTabela.cell_encode("option", att, option.text));
                }
                sb.append("</select>\n");
            }
            if (!(item.getValue() instanceof Vector)) continue;
            sb.append("<select id='" + item.getKey() + "'>\n");
            for (Object t : (Vector)item.getValue()) {
                sb.append(CBTabela.cell_encode("option", null, t.toString()));
            }
            sb.append("</select>\n");
        }
        sb.append("</table>\n");
        try {
            String xml = "<?xml version='1.0' encoding='utf-8'?>\n" + sb.toString();
            new CHEnvio.table_to_excel(xml.getBytes("utf-8"), face).start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void excel_columns(StringBuffer sb, HashMap<String, Object> sm) {
        int h = 0;
        while (h < this.handler.cdx.length) {
            Object sel;
            DecimalFormat df;
            Component c;
            int j = this.handler.cdx[h];
            sb.append("<col name='" + this.cols[j].col_tag + "'");
            TableColumn tc = this.handler.j.getColumnModel().getColumn(h);
            sb.append(" width='" + tc.getWidth() + "'");
            if (this.cols[j].is_check) {
                sb.append(" align='center'");
            } else if (tc.getCellRenderer() != null && (c = tc.getCellRenderer().getTableCellRendererComponent(this.handler.j, null, false, false, 0, h)) instanceof JLabel) {
                int ha = ((JLabel)c).getHorizontalAlignment();
                if (ha == 0) {
                    sb.append(" align='center'");
                }
                if (ha == 4) {
                    sb.append(" align='right'");
                }
            }
            if (this.cols[j].vld == null) {
                if (this.is_text_column(j)) {
                    sb.append(" format='@'");
                }
            } else if (this.cols[j].vld instanceof CFTypeNumber) {
                df = ((CFTypeNumber)this.cols[j].vld).FMT;
                sb.append(" format='" + df.toPattern() + "'");
            } else if (this.cols[j].vld instanceof CFType_Formula) {
                df = ((CFType_Formula)this.cols[j].vld).FMT;
                sb.append(" format='" + df.toPattern() + "'");
            } else if (this.cols[j].vld instanceof CFType_Data) {
                sb.append(" format='yyyy-MM-dd'");
            } else if (this.cols[j].vld instanceof CFType_AnoMes) {
                sb.append(" format='yyyy-MM'");
            }
            if (!this.cols[j].editable) {
                sb.append(" locked='true'");
            }
            if ((sel = this.getSelectValues(h)) != null) {
                sm.put(this.cols[j].col_tag, sel);
                sb.append(" select='" + this.cols[j].col_tag + "'");
            }
            sb.append("/>\n");
            ++h;
        }
    }

    private void excel_header(StringBuffer sb) {
        int h = 0;
        while (h < this.handler.cdx.length) {
            String hval = this.handler.j.getColumnModel().getColumn(h).getHeaderValue().toString();
            sb.append("<th>").append(CBTabela.clean_escape(hval)).append("</th>\n");
            ++h;
        }
    }

    private void excel_ui(int y, StringBuffer sb) {
        for (Object obj : this.ui.hcols) {
            GroupableTableHeaderUI.Col col = (GroupableTableHeaderUI.Col)obj;
            if (col.iy != y) continue;
            sb.append("<th");
            if (col.dx > 1) {
                sb.append(" colspan='" + col.dx + "'");
            }
            if (col.dy > 1) {
                sb.append(" rowspan='" + col.dy + "'");
            }
            sb.append(">").append(CBTabela.clean_escape(col.tag)).append("</th>\n");
        }
    }

    private void excel_data_row(int i, StringBuffer sb, HashMap<String, Object> sm, int fixed, boolean row_lock) {
        CHTabQuadro quadro = this.handler instanceof CHTabQuadro ? (CHTabQuadro)this.handler : null;
        String[] row = this.dados.elementAt(i);
        int h = 0;
        while (h < this.handler.cdx.length) {
            boolean lock;
            int p;
            String f;
            int n;
            int n2;
            String[] stringArray;
            String s2;
            String formula;
            int j = this.handler.cdx[h];
            String value = row[j];
            if (this.cols[j].is_check) {
                String string = value = value == "1" ? "x" : "";
            }
            if ((formula = this.cols[j].autocalc) != null) {
                try {
                    if (formula.toLowerCase().startsWith("$soma")) {
                        s2 = new String("=");
                        stringArray = formula.substring(6, formula.length() - 1).split(",");
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            f = stringArray[n];
                            p = this.cols[Integer.parseInt((String)f.substring((int)1))].t_col + fixed;
                            s2 = String.valueOf(s2) + f.charAt(0) + "R" + i + "C" + p;
                            ++n;
                        }
                        value = s2;
                    }
                }
                catch (Exception s2) {
                    // empty catch block
                }
            }
            if (!this.cols[j].disable_row_calc && this.cols[j].vld != null && quadro != null && (formula = quadro.row_autocalc[i]) != null) {
                try {
                    if (formula.toLowerCase().startsWith("$soma")) {
                        s2 = new String("=");
                        stringArray = formula.substring(6, formula.length() - 1).split(",");
                        n2 = stringArray.length;
                        n = 0;
                        while (n < n2) {
                            f = stringArray[n];
                            p = Integer.parseInt(f.substring(1));
                            int q = h + fixed;
                            s2 = String.valueOf(s2) + f.charAt(0) + "R" + p + "C" + q;
                            ++n;
                        }
                        value = s2;
                    }
                }
                catch (Exception s3) {
                    // empty catch block
                }
            }
            boolean bl = lock = row_lock || !this.cols[j].editable;
            String att = lock == this.isCellPastable(i, h) ? " locked='" + !lock + "'" : null;
            Object sel = this.getSelectValues(i, h);
            if (sel != null) {
                sm.put(String.valueOf(this.cols[j].col_tag) + "_" + i, sel);
                att = String.valueOf(att) + " select='" + this.cols[j].col_tag + "'";
            }
            sb.append(CBTabela.cell_encode(this.cols[j].col_tag, att, value));
            ++h;
        }
    }

    private static String clean_escape(String html) {
        return html.replaceAll("<br.*?>", "\n").replaceAll("<.*?>", "").replaceAll("&", "&amp;").replaceAll("<", "&lt;");
    }

    private static String cell_encode(String tag, String att, String value) {
        String opt;
        String string = opt = att == null || att.length() == 0 ? tag : String.valueOf(tag) + att;
        if (value == null || value.length() == 0) {
            return "<" + opt + "/>\n";
        }
        return "<" + opt + ">" + value.replaceAll("&", "&amp;").replaceAll("<", "&lt;") + "</" + tag + ">\n";
    }

    String get_caption() {
        Container p = this.handler.j;
        while (p != null && !(p instanceof JPanel)) {
            p = p.getParent();
        }
        if (p != null) {
            Component[] componentArray = ((JPanel)p).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof JLabel) {
                    return CBTabela.clean_escape(((JLabel)c).getText());
                }
                ++n2;
            }
        }
        return "";
    }

    boolean is_text_column(int j) {
        int i = 0;
        while (i < this.dados.size()) {
            String value = this.dados.elementAt(i)[j];
            if (value != null && value.length() != 0 && !numberMatch.matcher(value).matches()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected class ExcelOption {
        String dependsOn = null;
        String value = null;
        String text = null;

        ExcelOption(String text) {
            this.text = text;
        }
    }

    protected class ExcelSelect {
        String dependsOn = null;
        Vector<ExcelOption> list = new Vector();

        protected ExcelSelect() {
        }
    }
}

